package ru.yandex.travel.budapest.rooms.backend.services.hello;

import javax.annotation.Nonnull;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import ru.yandex.travel.budapest.rooms.backend.Rooms;
import ru.yandex.travel.budapest.rooms.backend.repositories.hello.HelloRoomsHotelsRepository;
import ru.yandex.travel.budapest.rooms.backend.repositories.hello.HelloRoomsOffersRepository;

@Service
public class HelloService {

    @Nonnull
    private final HelloRoomsHotelsRepository helloRoomsHotelsRepository;
    @Nonnull
    private final HelloRoomsOffersRepository helloRoomsOffersRepository;


    public HelloService(
            @Nonnull
            final HelloRoomsHotelsRepository helloRoomsHotelsRepository
            ,
            @Nonnull
            final HelloRoomsOffersRepository helloRoomsOffersRepository
    ) {
        this.helloRoomsHotelsRepository = helloRoomsHotelsRepository;
        this.helloRoomsOffersRepository = helloRoomsOffersRepository;
    }

    @Nonnull
    @Transactional(transactionManager = Rooms.ROOMS_HOTELS)
    public String helloRoomsHotels() {
        return helloRoomsHotelsRepository.hello();
    }

    @Nonnull
    @Transactional(transactionManager = Rooms.ROOMS_OFFERS)
    public String helloRoomsOffers() {
        return helloRoomsOffersRepository.hello();
    }
}
