RECURSE_FOR_TESTS(
    src/test
)

JAVA_PROGRAM(rooms-backend)

JDK_VERSION(11)
INCLUDE(${ARCADIA_ROOT}/travel/library/java/dependencies.inc)
INCLUDE(${ARCADIA_ROOT}/travel/library/java/lombok.inc)

# todo добавить группу Будапешт
OWNER(
    g:travel-hotels
    g:travel
)


JAVA_SRCS(SRCDIR src/main/java **/*)
JAVA_SRCS(SRCDIR src/main/resources **/*)

EXCLUDE(
    # replaced by org.dom4j
    contrib/java/dom4j/dom4j

    contrib/java/ch/qos/logback/logback-core
    contrib/java/ru/yandex/iceberg-bolts
    contrib/java/ru/yandex/iceberg-misc

)

PEERDIR(
    travel/library/java/spring-boot-skeleton
#    contrib/java/io/springfox/springfox-boot-starter
    contrib/java/io/springfox/springfox-swagger2
    contrib/java/io/springfox/springfox-swagger-ui

    # JDK 11 does not javax.xml.bind.* packages
    contrib/java/javax/xml/bind/jaxb-api/2.3.0
    contrib/java/com/sun/xml/bind/jaxb-impl/2.3.0
    contrib/java/com/sun/xml/bind/jaxb-core/2.3.0

    contrib/java/org/springframework/boot/spring-boot-starter-jdbc
    contrib/java/org/postgresql/postgresql
    contrib/java/net/ttddyy/datasource-proxy/1.5.1
)

GENERATE_SCRIPT(
    TEMPLATE ${ARCADIA_ROOT}/travel/budapest/rooms/devops/starter/starter.template.py
    OUT ${BINDIR}/bin/rooms-backend.py
    CUSTOM_PROPERTY appName rooms-backend
    CUSTOM_PROPERTY mainClass ru.yandex.travel.budapest.rooms.backend.RoomsBackendApplication
)

# Added automatically to remove dependency on default contrib versions
DEPENDENCY_MANAGEMENT(
    contrib/java/one/util/streamex/0.7.2
    contrib/java/org/jxls/jxls/2.8.1
    contrib/java/org/jxls/jxls-poi/2.8.1
    contrib/java/org/apache/poi/poi/4.1.2
    contrib/java/org/apache/poi/poi-ooxml/4.1.2
    contrib/java/org/apache/poi/poi-ooxml-schemas/4.1.2
    contrib/java/com/netflix/concurrency-limits/concurrency-limits-core/0.3.6
    contrib/java/org/postgresql/postgresql/42.3.3
)

LINT(base)
END()
