JAVA_PROGRAM(rooms-migration-db)

JDK_VERSION(11)
INCLUDE(${ARCADIA_ROOT}/travel/library/java/dependencies.inc)

# todo добавить группу Будапешт
OWNER(
    g:travel-hotels
    g:travel
)

JAVA_SRCS(SRCDIR src/main/java **/*)
JAVA_SRCS(SRCDIR src/main/resources **/*)

EXCLUDE(
    # replaced by org.dom4j
    contrib/java/dom4j/dom4j

    contrib/java/ch/qos/logback/logback-core
    contrib/java/ru/yandex/iceberg-bolts
    contrib/java/ru/yandex/iceberg-misc
)

PEERDIR(
    contrib/java/org/springframework/boot/spring-boot-starter
    contrib/java/org/springframework/boot/spring-boot-starter-jdbc
    contrib/java/org/springframework/boot/spring-boot-starter-log4j2
    contrib/java/org/flywaydb/flyway-core
    contrib/java/org/postgresql/postgresql
)

DEPENDENCY_MANAGEMENT(
    contrib/java/org/postgresql/postgresql/42.3.3
)

GENERATE_SCRIPT(
    TEMPLATE ${ARCADIA_ROOT}/travel/budapest/rooms/devops/starter/starter.template.py
    OUT ${BINDIR}/bin/rooms-migration-db.py
    CUSTOM_PROPERTY appName rooms-migration-db
    CUSTOM_PROPERTY mainClass ru.yandex.travel.budapest.rooms.migration.RoomsMigrationApplication
)

LINT(base)
END()
