package main

import "a.yandex-team.ru/travel/hotels/tools/boy_hotels_checker/pkg/cfg"

const bitrixPrefix = "https://yameta.bitrix24.ru/rest/281"
const foodPromoField = "UF_CRM_1622032303674"
const taxiPromoField = "UF_CRM_1622032314072"
const lavkaPromoField = "UF_CRM_1622032332118"
const plusPromoField = "UF_CRM_1622032352962"
const hotelPromoField = "UF_CRM_1623146087462"

var bitrixSecret = cfg.ConfigurableSetting{
	Name:        "bitrix-secret",
	Description: "Bitrix endpoint secret",
	IsSecret:    true,
	LoadFromEnv: true,
	Required:    true,
}

var ytToken = cfg.ConfigurableSetting{
	Name:        "yt-token",
	Description: "YT token",
	SecretID:    "sec-01d8t7zednvzpayps7k0pf12vb",
	SecretName:  "yt-oauth-key",
	LoadFromEnv: true,
	EnvVarName:  "YT_TOKEN",
	Required:    true,
	IsSecret:    true,
}

var ytProxy = cfg.ConfigurableSetting{
	Name:        "yt-proxy",
	Value:       "hahn",
	Description: "YT proxy",
	LoadFromEnv: true,
	EnvVarName:  "YT_PROXY",
	Required:    true,
}

var ytPath = cfg.ConfigurableSetting{
	Name:        "yt-path",
	Value:       "//home/travel/budapest",
	Description: "path to YT-directory with promo codes",
	LoadFromEnv: true,
	Required:    true,
}

func getSettings() []*cfg.ConfigurableSetting {
	return []*cfg.ConfigurableSetting{
		&bitrixSecret,
		&ytToken,
		&ytProxy,
		&ytPath,
	}
}
