package app

import (
	"context"
	"errors"

	"a.yandex-team.ru/travel/proto/buses"

	apipb "a.yandex-team.ru/travel/buses/backend/proto/api"
)

func (a *App) CreateRideOffer(ctx context.Context, rideID string, labelParams *buses.TLabelParams, retry int) (*apipb.TOffer, string, string, error) {
	// BUSES-767 We do not know for sure, but 2 retries should be enough (equals 3 attempts to find)
	const maxRetries = 2

	rideResult, status := a.Ride(rideID, true, ctx)

	if !status.Ok() {
		return nil, "", "", errors.New(status.String())
	}

	if rideResult.SubstitutionID != "" {
		if retry < maxRetries {
			return a.CreateRideOffer(ctx, rideResult.SubstitutionID, labelParams, retry+1)
		}
		return nil, "", "", errors.New("max retries exceeded")
	}

	labelHash, err := a.redir.StoreLabelParams(ctx, labelParams)
	if err != nil {
		a.logger.Errorf("Store label params: %s", err)
		// TODO return this
		//return nil, "", "", fmt.Errorf("store label params: %s", err)
	}

	offer := &apipb.TOffer{
		QueryFrom:  rideResult.QueryFrom,
		QueryTo:    rideResult.QueryTo,
		Ride:       rideResult.Ride,
		BookParams: rideResult.BookParams,
	}
	offerID, err := a.SaveOffer(ctx, offer)
	if err != nil {
		return nil, "", "", err
	}
	return offer, offerID.String(), labelHash, nil
}
