package app

import (
	"fmt"

	"google.golang.org/grpc/connectivity"

	pb "a.yandex-team.ru/travel/buses/backend/proto"
)

func (a *App) HealthStatus() *StatusWithMessage {
	const logMessage = "App.HealthStatus"

	if !a.onAir.Load() {
		// qloud не считает 202 ошибкой
		return NewStatusWithMessage(pb.EStatus_STATUS_INTERNAL_ERROR,
			fmt.Sprintf("%s: app is starting", logMessage))
	}

	if err := a.ctx.Err(); err != nil {
		return NewStatusWithMessage(pb.EStatus_STATUS_INTERNAL_ERROR,
			fmt.Sprintf("%s: app context error: %s", logMessage, err.Error()))
	}

	if err := a.searchConsumer.Err(); err != nil {
		return NewStatusWithMessage(pb.EStatus_STATUS_EXTERNAL_ERROR,
			fmt.Sprintf("%s: searchConsumer closed: %s", logMessage, err.Error()))
	}
	if err := a.segmentsConsumer.Err(); err != nil {
		return NewStatusWithMessage(pb.EStatus_STATUS_EXTERNAL_ERROR,
			fmt.Sprintf("%s: segmentsConsumer closed: %s", logMessage, err.Error()))
	}

	if a.workerServiceConnection.GetState() != connectivity.Ready {
		return NewStatusWithMessage(pb.EStatus_STATUS_EXTERNAL_ERROR,
			fmt.Sprintf("%s: worker service connection %s", logMessage,
				a.workerServiceConnection.GetState().String()))
	}

	return NewStatusWithMessage(pb.EStatus_STATUS_OK, "")
}
