package app

import (
	"context"
	"fmt"

	"github.com/gofrs/uuid"

	apipb "a.yandex-team.ru/travel/buses/backend/proto/api"
)

func (a *App) SaveOffer(ctx context.Context, offer *apipb.TOffer) (uuid.UUID, error) {
	const funcName = "App.SaveOffer"

	offerID, err := a.offerStorage.SaveOffer(ctx, offer)
	if err != nil {
		return offerID, fmt.Errorf("%s: offer save error: %w", funcName, err)
	}
	return offerID, nil
}

func (a *App) GetOffer(ctx context.Context, offerID uuid.UUID) (*apipb.TOffer, error) {
	const funcName = "App.GetOffer"
	offer, err := a.offerStorage.GetOffer(ctx, offerID)
	if err != nil {
		return nil, fmt.Errorf("%s: get offer error: %w", funcName, err)
	}
	return offer, nil
}
