package app

import (
	"fmt"

	pb "a.yandex-team.ru/travel/buses/backend/proto"
)

type StatusWithMessage struct {
	Status  pb.EStatus
	Message string
}

func NewStatusWithMessage(status pb.EStatus, message string) *StatusWithMessage {
	return &StatusWithMessage{Status: status, Message: message}
}

func (s *StatusWithMessage) String() string {
	if s == nil {
		return "nil"
	}
	return fmt.Sprintf("%s: %s", s.Status, s.Message)
}

func (s *StatusWithMessage) Ok() bool {
	return s != nil && s.Status == pb.EStatus_STATUS_OK
}
