package app

import (
	tpb "a.yandex-team.ru/travel/proto"
	"context"

	"a.yandex-team.ru/travel/buses/backend/proto/worker"
)

func (a *App) Book(ctx context.Context, request *worker.TBookRequest) (*worker.TBookResponse, error) {
	book, err := a.workerServiceClient.Book(ctx, request)
	if err == nil && book.Header.Code == tpb.EErrorCode_EC_OK {
		if order, err := a.billingDict.WithRevenue(book.Order, request.SupplierId); err == nil {
			book = &worker.TBookResponse{
				Header: book.Header,
				Order:  order,
			}
		} else {
			a.logger.Warnf("cannot add order revenue: %s", err.Error())
		}
	}
	return book, err
}

func (a *App) Confirm(ctx context.Context, request *worker.TConfirmRequest) (*worker.TConfirmResponse, error) {
	book, err := a.workerServiceClient.Confirm(ctx, request)
	return book, err
}

func (a *App) CancelBooking(ctx context.Context, request *worker.TCancelBookingRequest) (*worker.TCancelBookingResponse, error) {
	book, err := a.workerServiceClient.CancelBooking(ctx, request)
	return book, err
}

func (a *App) RefundInfo(ctx context.Context, request *worker.TRefundInfoRequest) (*worker.TRefundInfoResponse, error) {
	book, err := a.workerServiceClient.RefundInfo(ctx, request)
	return book, err
}

func (a *App) Refund(ctx context.Context, request *worker.TRefundRequest) (*worker.TRefundResponse, error) {
	book, err := a.workerServiceClient.Refund(ctx, request)
	return book, err
}
