package blacklist

import (
	"encoding/json"
)

type (
	parsedItem struct {
		path     []string
		operator string
		value    interface{}
	}
	parsedRule  []parsedItem
	parsedRules []parsedRule
)

func parse(rawRules map[string]interface{}) (result parsedRule) {
	for key, rawValue := range rawRules {
		switch key[0] {
		case '#':
			continue
		case '$':
			result = append(result, parsedItem{value: rawValue, operator: key})
			continue
		}

		var path = []string{key}

		if mapValue, ok := rawValue.(map[string]interface{}); ok {
			for _, subrule := range parse(mapValue) {
				result = append(result, parsedItem{
					path:     append(path, subrule.path...),
					operator: subrule.operator,
					value:    subrule.value,
				})
			}
			continue
		}

		result = append(result, parsedItem{path: path, value: rawValue})
	}

	return
}

func parseJSONRules(blacklistJSON string) (parsedRules, error) {
	var rawRules []map[string]interface{}
	if err := json.Unmarshal([]byte(blacklistJSON), &rawRules); err != nil {
		return nil, err
	}

	var result = make(parsedRules, 0, len(rawRules))
	for _, rawRule := range rawRules {
		result = append(result, parse(rawRule))
	}
	return result, nil
}
