package blacklist

import (
	"fmt"
	"reflect"

	"a.yandex-team.ru/travel/buses/backend/internal/api/filters"
	pb "a.yandex-team.ru/travel/buses/backend/proto"
)

type (
	predicate        func(searchInfo *filters.SearchInfo, ride *pb.TRide) bool
	predicateFactory func(ruleValue interface{}, converter converter) (predicate, error)
)

func predicateEquals(ruleValue interface{}, converter converter) (predicate, error) {
	var srcValue, err = converter.fromRuleValue(ruleValue)
	if err != nil {
		return nil, err
	}
	return func(searchInfo *filters.SearchInfo, ride *pb.TRide) bool {
		var dstValue = converter.fromSearchRide(searchInfo, ride)
		return srcValue == dstValue
	}, nil
}

func predicateFoundSuppliers(ruleValue interface{}, converter foundSuppliersConverter) (predicate, error) {
	var srcValue, err = converter.fromRuleValue(ruleValue)
	if err != nil {
		return nil, err
	}

	var supplierID = uint32(srcValue.(comparableInteger))
	return func(searchInfo *filters.SearchInfo, ride *pb.TRide) bool {
		var supplierIds = converter.fromSearchRide(searchInfo, ride).(comparableIntegers)
		return supplierIds[supplierID]
	}, nil
}

func makeContainedPredicate(expected bool) predicateFactory {
	return func(ruleValue interface{}, converter converter) (predicate, error) {
		var valueArray, ok = ruleValue.([]interface{})
		if !ok {
			return nil, fmt.Errorf("operator argument is %s instead of array", reflect.TypeOf(ruleValue))
		}

		var srcSet = map[comparableValue]bool{}
		for _, v := range valueArray {
			var srcItem, err = converter.fromRuleValue(v)
			if err != nil {
				return nil, err
			}
			srcSet[srcItem] = true
		}

		return func(searchInfo *filters.SearchInfo, ride *pb.TRide) bool {
			var found = srcSet[converter.fromSearchRide(searchInfo, ride)]
			return found == expected
		}, nil
	}
}
