package config

import (
	"context"

	"a.yandex-team.ru/travel/library/go/configuration"
	metricsserver "a.yandex-team.ru/travel/library/go/metrics/server"

	"a.yandex-team.ru/travel/buses/backend/internal/api/app"
	"a.yandex-team.ru/travel/buses/backend/internal/api/httpserver"
	"a.yandex-team.ru/travel/buses/backend/internal/common/grpc"
	"a.yandex-team.ru/travel/buses/backend/internal/common/logging"
)

type Config struct {
	EnvType string `config:"envtype,required"`
	Logging logging.Config
	HTTP    httpserver.Config
	GRPC    grpc.ServerConfig
	Metrics metricsserver.MetricsConfig
	App     app.Config
}

var cfg = Config{
	EnvType: "development",
	Logging: logging.DefaultConfig,
	HTTP:    httpserver.DefaultConfig,
	GRPC:    grpc.DefaultServerConfig,
	Metrics: metricsserver.DefaultMetricsConfig,
	App:     app.DefaultConfig,
}

func Load() (Config, error) {
	loader := configuration.NewDefaultConfitaLoader()
	return cfg, loader.Load(context.Background(), &cfg)
}
