package filters

import (
	pb "a.yandex-team.ru/travel/buses/backend/proto"
)

type SearchInfo struct {
	DeparturePK      *pb.TPointKey
	ArrivalPK        *pb.TPointKey
	FoundSupplierIds map[uint32]bool
}

func newSearchInfo(departurePK *pb.TPointKey, arrivalPK *pb.TPointKey, rides []*pb.TRide) *SearchInfo {
	var supplierIds = map[uint32]bool{}
	for _, ride := range rides {
		supplierIds[ride.SupplierId] = true
	}
	return &SearchInfo{DeparturePK: departurePK, ArrivalPK: arrivalPK, FoundSupplierIds: supplierIds}
}
