package grpcserver

import (
	"context"

	apipb "a.yandex-team.ru/travel/buses/backend/proto/api"
)

func (h handler) CreateRideOffer(ctx context.Context, request *apipb.CreateRideOfferRequest) (*apipb.CreateRideOfferResponse, error) {
	offer, offerID, labelHash, err := h.app.CreateRideOffer(ctx, request.RideId, request.LabelParams, 0)
	if err != nil {
		return &apipb.CreateRideOfferResponse{
			Error: err.Error(),
		}, nil
	}
	return &apipb.CreateRideOfferResponse{
		Offer:     offer,
		OfferId:   offerID,
		LabelHash: labelHash,
	}, nil
}
