package grpcserver

import (
	"context"

	"github.com/gofrs/uuid"

	apipb "a.yandex-team.ru/travel/buses/backend/proto/api"
)

func (h handler) GetOffer(ctx context.Context, request *apipb.GetOfferRequest) (*apipb.GetOfferResponse, error) {
	offerID, err := uuid.FromString(request.OfferId)
	if err != nil {
		return &apipb.GetOfferResponse{
			Error: err.Error(),
		}, nil
	}
	offer, err := h.app.GetOffer(ctx, offerID)
	if err != nil {
		return &apipb.GetOfferResponse{
			Error: err.Error(),
		}, nil
	}
	return &apipb.GetOfferResponse{
		Offer: offer,
	}, nil
}
