package handler

import (
	"encoding/json"
	"github.com/go-chi/chi/v5"
	"net/http"
	"net/url"
)

func (h *Handler) PointByPointkey(w http.ResponseWriter, r *http.Request) {
	const errorMessage = "Handler.PointByPointkey"

	pointkey := chi.URLParam(r, "pointkey")
	point, status := h.app.GetPointByPointkey(pointkey)
	w.Header().Set("Content-Type", "application/json")
	if !status.Ok() {
		w.WriteHeader(h.httpCodeForStatus(status))
		response, _ := json.Marshal(JSONErrorMapper{Error: status.String()})
		_, _ = w.Write(response)
		return
	}

	pointJSON, err := json.Marshal(point)
	if err != nil {
		h.logger.Errorf("%s: %s", errorMessage, err.Error())
		w.WriteHeader(http.StatusInternalServerError)
		response, _ := json.Marshal(JSONErrorMapper{Error: err.Error()})
		_, _ = w.Write(response)
		return
	}

	w.WriteHeader(http.StatusOK)
	_, _ = w.Write(pointJSON)
}

func (h *Handler) Points(w http.ResponseWriter, r *http.Request) {
	const errorMessage = "Handler.Points"

	params, _ := url.ParseQuery(r.URL.RawQuery)
	where := params.Get("where")

	w.Header().Set("Content-Type", "application/json")

	if where == "" {
		w.WriteHeader(http.StatusBadRequest)
		response, _ := json.Marshal(JSONErrorMapper{Error: "where required"})
		_, _ = w.Write(response)
		return
	}

	points, status := h.app.GetPointsWhere(where)
	if !status.Ok() {
		w.WriteHeader(h.httpCodeForStatus(status))
		response, _ := json.Marshal(JSONErrorMapper{Error: status.String()})
		_, _ = w.Write(response)
		return
	}

	pointsJSON, err := json.Marshal(points)
	if err != nil {
		h.logger.Errorf("%s: %s", errorMessage, err.Error())
		w.WriteHeader(http.StatusInternalServerError)
		response, _ := json.Marshal(JSONErrorMapper{Error: err.Error()})
		_, _ = w.Write(response)
		return
	}

	w.WriteHeader(http.StatusOK)
	_, _ = w.Write(pointsJSON)
}
