package handler

import (
	"encoding/json"
	"net/http"
	"net/url"
	"strconv"

	ipb "a.yandex-team.ru/travel/buses/backend/internal/common/proto"
	"a.yandex-team.ru/travel/buses/backend/internal/common/utils"
)

func (h *Handler) Popular(w http.ResponseWriter, r *http.Request) {
	const (
		errorMessage = "Handler.Popular"
		defaultLimit = 15
	)

	w.Header().Set("Content-Type", "application/json")

	var directions *ipb.TPopularDirectionsResponse
	params, _ := url.ParseQuery(r.URL.RawQuery)
	limit, err := strconv.Atoi(params.Get("limit"))
	if err != nil {
		limit = defaultLimit
	}
	fromID, ok := params["from-id"]
	if !ok {
		directions = h.app.GetPopularDirections(limit, r.Context())
	} else {
		from, err := utils.LoadPointKey(fromID[0])
		if err != nil {
			w.WriteHeader(http.StatusBadRequest)
			response, _ := json.Marshal(JSONErrorMapper{Error: "ride-id: bad format"})
			_, _ = w.Write(response)
			return
		}
		directions = h.app.GetPopularDirectionsFrom(from, limit, r.Context())
	}
	directionsJSON, err := json.Marshal(directions)
	if err != nil {
		h.logger.Errorf("%s: %s", errorMessage, err.Error())
		w.WriteHeader(http.StatusInternalServerError)
		response, _ := json.Marshal(JSONErrorMapper{Error: err.Error()})
		_, _ = w.Write(response)
		return
	}
	w.WriteHeader(http.StatusOK)
	_, _ = w.Write(directionsJSON)
}
