package handler

import (
	"encoding/json"
	"net/http"
	"net/url"

	"a.yandex-team.ru/travel/buses/backend/internal/common/logging"
	"a.yandex-team.ru/travel/buses/backend/internal/common/utils"
	pb "a.yandex-team.ru/travel/buses/backend/proto"
)

func (h *Handler) RaspSearch(w http.ResponseWriter, r *http.Request) {
	const logMessage = "Handler.RaspSearch"

	w.Header().Set("Content-Type", "application/json")

	params, _ := url.ParseQuery(r.URL.RawQuery)
	searchPrms, err := parseSearchParams(params)
	if err != nil {
		w.WriteHeader(http.StatusBadRequest)
		response, _ := json.Marshal(JSONErrorMapper{Error: err.Error()})
		_, _ = w.Write(response)
		return
	}

	rides, ready := h.app.Search(searchPrms.From, searchPrms.To, searchPrms.Date, true, pb.ERequestSource_SRS_RASP_SEARCH, r.Context())

	responseStatus := http.StatusOK
	if !ready {
		responseStatus = http.StatusAccepted
	}

	var response []byte
	responseJSON, errJSON := ridesToJSONRides(rides)
	if errJSON == nil {
		fromStr, _ := utils.DumpPointKey(searchPrms.From)
		toStr, _ := utils.DumpPointKey(searchPrms.To)
		raspJSON := RaspRides(responseJSON, fromStr, toStr, utils.DumpDate(searchPrms.Date))
		response, err = json.Marshal(raspJSON)
	}

	if err != nil {
		logging.WithRequestContext(h.logger, r.Context()).Error(err.Error())
		w.WriteHeader(http.StatusInternalServerError)
		response, _ = json.Marshal(JSONErrorMapper{Error: err.Error()})
		_, _ = w.Write(response)
		return
	}

	w.WriteHeader(responseStatus)
	_, _ = w.Write(response)
}
