package handler

import (
	"encoding/json"
	"net/http"
	"net/url"
	"strconv"

	pb "a.yandex-team.ru/travel/buses/backend/proto"
)

type rideResponse struct {
	*pb.TRide

	// Do not use TRide field names here.
	// Otherwise, json.Marshal would silently ignore their values in this struct and TRide.
	BookParams   *pb.TBookParams
	Substitution string
}

func (h *Handler) Ride(w http.ResponseWriter, r *http.Request) {
	const errorMessage = "Handler.Ride"
	params, _ := url.ParseQuery(r.URL.RawQuery)
	rideID := params.Get("ride-id")
	if rideID == "" {
		w.WriteHeader(http.StatusBadRequest)
		response, _ := json.Marshal(JSONErrorMapper{Error: "ride-id required"})
		_, _ = w.Write(response)
		return
	}
	allowSubstitution, errAllowSubstitution := strconv.ParseBool(params.Get("allow-substitution"))
	if errAllowSubstitution != nil {
		allowSubstitution = true
	}

	rideResult, status := h.app.Ride(rideID, allowSubstitution, r.Context())
	w.Header().Set("Content-Type", "application/json")
	if !status.Ok() {
		w.WriteHeader(h.httpCodeForStatus(status))
		response, _ := json.Marshal(JSONErrorMapper{Error: status.String()})
		_, _ = w.Write(response)
		return
	}

	rideJSON, err := json.Marshal(rideResponse{
		TRide:        rideResult.Ride,
		BookParams:   rideResult.BookParams,
		Substitution: rideResult.SubstitutionID,
	})
	if err != nil {
		h.logger.Errorf("%s: %s", errorMessage, err.Error())
		w.WriteHeader(http.StatusInternalServerError)
		response, _ := json.Marshal(JSONErrorMapper{Error: err.Error()})
		_, _ = w.Write(response)
		return
	}

	w.WriteHeader(http.StatusOK)
	_, _ = w.Write(rideJSON)
}
