package connector

import (
	"fmt"

	wpb "a.yandex-team.ru/travel/buses/backend/proto/worker"
)

func (c *HTTPClient) PostConfirm(orderID string) (*wpb.TOrder, *wpb.TExplanation, error) {
	const funcName = "HTTPClient.PostConfirm"

	var response, err = c.post(fmt.Sprintf("orders/%s/confirm?explain=1", orderID), nil, c.cfg.Timeout)
	if err != nil {
		return nil, nil, fmt.Errorf("%s: %w", funcName, err)
	}

	var jsonOrderWithExplain JSONOrderWithExplain
	defer func() { _ = response.Body.Close() }()
	if err := readJSON(response.Body, &jsonOrderWithExplain); err != nil {
		return nil, buildExplanation(response, nil), fmt.Errorf("%s: %w", funcName, err)
	}

	order, err := convertOrderToProto(jsonOrderWithExplain.Result)
	return order, buildExplanation(response, jsonOrderWithExplain.Explain), err
}
