package connector

import (
	"fmt"
	"net/http"
)

type ErrWithMetadata struct {
	Code    uint32
	Message string
}

func (e ErrWithMetadata) Error() string {
	return fmt.Sprintf("connector error: %s [Code = %d]", e.Message, e.Code)
}

type ErrUnavailable struct {
	wrapped error
}

func (e ErrUnavailable) Error() string {
	return fmt.Sprintf("connector unavailable: %v", e.wrapped)
}

func (e ErrUnavailable) Unwrap() error {
	return e.wrapped
}

func NewErrUnavailable(wrapped error) ErrUnavailable {
	return ErrUnavailable{wrapped}
}

func errorFromResponse(response *http.Response) error {
	switch response.StatusCode {
	case http.StatusOK:
		return nil
	case http.StatusUnprocessableEntity, http.StatusBadGateway: // 422, 502
		var errorData JSONErrorMapper
		if err := readJSON(response.Body, &errorData); err == nil {
			return ErrWithMetadata{Code: errorData.Error.Code, Message: errorData.Error.Message}
		}
	}
	return NewErrUnavailable(fmt.Errorf("bad response code: %d", response.StatusCode))
}
