package connector

import (
	"fmt"

	tpb "a.yandex-team.ru/travel/proto"

	wpb "a.yandex-team.ru/travel/buses/backend/proto/worker"
)

func (c *HTTPClient) PostRefund(ticketID string) (*wpb.TRefund, *wpb.TExplanation, error) {
	const funcName = "HTTPClient.PostRefund"

	var response, err = c.post(fmt.Sprintf("tickets/%s/refund?explain=1", ticketID), nil, c.cfg.Timeout)
	if err != nil {
		return nil, nil, fmt.Errorf("%s: %w", funcName, err)
	}

	var jsonRefundWithExplain JSONRefundWithExplain
	defer func() { _ = response.Body.Close() }()
	if err := readJSON(response.Body, &jsonRefundWithExplain); err != nil {
		return nil, buildExplanation(response, nil), fmt.Errorf("%s: %w", funcName, err)
	}

	return &wpb.TRefund{
			Price: &tpb.TPrice{
				Amount:    int64(jsonRefundWithExplain.Result.Price * 100),
				Currency:  tpb.ECurrency_C_RUB,
				Precision: pricePrecision,
			},
		},
		buildExplanation(response, jsonRefundWithExplain.Explain),
		nil
}
