package connector

import (
	"fmt"

	tpb "a.yandex-team.ru/travel/proto"

	wpb "a.yandex-team.ru/travel/buses/backend/proto/worker"
)

func (c *HTTPClient) GetRefundInfo(ticketID string) (*wpb.TRefundInfo, *wpb.TExplanation, error) {
	const funcName = "HTTPClient.GetRefundInfo"

	var response, err = c.get(fmt.Sprintf("tickets/%s/calc-refund?explain=1", ticketID), c.cfg.Timeout)
	if err != nil {
		return nil, nil, fmt.Errorf("%s: %w", funcName, err)
	}

	var jsonRefundInfoWithExplain JSONRefundInfoWithExplain
	defer func() { _ = response.Body.Close() }()
	if err := readJSON(response.Body, &jsonRefundInfoWithExplain); err != nil {
		return nil, buildExplanation(response, nil), fmt.Errorf("%s: %w", funcName, err)
	}

	return &wpb.TRefundInfo{
			Available: jsonRefundInfoWithExplain.Result.Available,
			Price: &tpb.TPrice{
				Amount:    int64(jsonRefundInfoWithExplain.Result.Price * 100),
				Currency:  tpb.ECurrency_C_RUB,
				Precision: pricePrecision,
			},
		},
		buildExplanation(response, jsonRefundInfoWithExplain.Explain),
		nil
}
