package connector

import (
	"fmt"

	"a.yandex-team.ru/library/go/core/log"

	"a.yandex-team.ru/travel/buses/backend/internal/common/utils"
	wpb "a.yandex-team.ru/travel/buses/backend/proto/worker"
)

func (c *HTTPClient) GetSegments() ([]*wpb.TSegment, *wpb.TExplanation, error) {
	const funcName = "HTTPClient.GetSegments"

	response, err := c.get("rides/segments?explain=1", c.cfg.SegmentsTimeout)
	if err != nil {
		return []*wpb.TSegment{}, nil, fmt.Errorf("%s: %w", funcName, err)
	}

	var jsonSegmentsWithExplain JSONSegmentsWithExplain
	defer func() { _ = response.Body.Close() }()
	if err := readJSON(response.Body, &jsonSegmentsWithExplain); err != nil {
		return nil, buildExplanation(response, nil), fmt.Errorf("segments result json unmarshal error: %w", err)
	}

	segments := convertSegmentsToProto(jsonSegmentsWithExplain.Result, c.logger)
	return segments, buildExplanation(response, jsonSegmentsWithExplain.Explain), nil
}

func convertSegmentsToProto(segments JSONSegments, logger log.Logger) []*wpb.TSegment {
	protoSegments := make([]*wpb.TSegment, len(segments.Segments))
	converted := 0
	for _, segment := range segments.Segments {
		if len(segment) != 2 {
			continue
		}
		from, errFrom := utils.LoadPointKey(segment[0])
		to, errTo := utils.LoadPointKey(segment[1])
		if errFrom != nil || errTo != nil {
			continue
		}
		protoSegments[converted] = &wpb.TSegment{
			From: from,
			To:   to,
		}
		converted++
	}
	if converted != len(segments.Segments) {
		logger.Errorf("convertSegmentsToProto: %d segments with errors", len(segments.Segments)-converted)
		return protoSegments[:converted]
	}
	return protoSegments
}
