package mock

import (
	"context"
	"sync"
	"time"

	tpb "a.yandex-team.ru/travel/proto"

	wpb "a.yandex-team.ru/travel/buses/backend/proto/worker"
)

type MockedWorker struct {
	wpb.UnimplementedWorkerServiceServer

	searchQueuePosition map[uint32]uint32
	mutex               *sync.Mutex
}

func NewMockedWorker() *MockedWorker {
	return &MockedWorker{
		mutex:               &sync.Mutex{},
		searchQueuePosition: make(map[uint32]uint32),
	}
}

func (w *MockedWorker) Search(_ context.Context, request *wpb.TSearchRequest) (*wpb.TSearchResponse, error) {
	w.mutex.Lock()
	defer w.mutex.Unlock()

	position, ok := w.searchQueuePosition[request.SupplierId]
	if !ok {
		position = 0
	}
	w.searchQueuePosition[request.SupplierId] = position + 1
	return &wpb.TSearchResponse{
		Header: &wpb.TResponseHeader{
			Code:      tpb.EErrorCode_EC_OK,
			Timestamp: time.Now().Unix(),
		},
		QueuePosition: position + 1,
	}, nil
}

func (w *MockedWorker) Segments(context.Context, *wpb.TSegmentsRequest) (*wpb.TSegmentsResponse, error) {
	return &wpb.TSegmentsResponse{
		Header: &wpb.TResponseHeader{
			Code:      tpb.EErrorCode_EC_OK,
			Timestamp: time.Now().Unix(),
		},
	}, nil
}
