package logging

import (
	"context"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/zap"
	"github.com/go-chi/chi/v5/middleware"
)

const (
	ComponentField      = "module"
	SupplierIDField     = "sId"
	LogbrokerQueueField = "lbQueue"
)

func With(zl *zap.Logger, fields ...log.Field) *zap.Logger {
	return zl.With(fields...).(*zap.Logger)
}

func WithModuleContext(zl *zap.Logger, module string) *zap.Logger {
	return With(
		zl,
		log.String(ComponentField, module),
	)
}

func WithLogbrokerContext(zl *zap.Logger, queue string) *zap.Logger {
	return With(
		zl,
		log.String(ComponentField, "logbroker"),
		log.String(LogbrokerQueueField, queue),
	)
}

func WithRequestContext(zl *zap.Logger, ctx context.Context) *zap.Logger {
	return With(
		zl,
		log.String(middleware.RequestIDHeader, middleware.GetReqID(ctx)),
	)
}

func WithSupplierContext(zl *zap.Logger, sID uint32) *zap.Logger {
	return With(
		zl,
		log.UInt32(SupplierIDField, sID),
	)
}
