package logging

import (
	"fmt"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/zap"
	uzap "go.uber.org/zap"
)

const (
	DeployLogger  = "deploy"
	ConsoleLogger = "console"
)

type Config struct {
	Level log.Level `config:"log-level,required"`
	Type  string    `config:"log-type,optional"`
}

var DefaultConfig = Config{
	Level: log.InfoLevel,
	Type:  DeployLogger,
}

func New(config *Config) (*zap.Logger, error) {
	var logger *zap.Logger
	var err error
	switch config.Type {
	case DeployLogger:
		logger, err = zap.NewDeployLogger(config.Level)
	case ConsoleLogger:
		logger, err = zap.New(zap.ConsoleConfig(config.Level))
	default:
		return nil, fmt.Errorf("unknown logger type: %s", config.Type)
	}
	if err != nil {
		return nil, fmt.Errorf("cannot create logger with type \"%s\": %w", config.Type, err)
	}

	return logger, nil
}

func IncreaseLevel(logger *zap.Logger, level log.Level) *zap.Logger {
	return &zap.Logger{L: logger.L.WithOptions(uzap.IncreaseLevel(zap.ZapifyLevel(level)))}
}
