package utils

import (
	"fmt"
	"time"

	pb "a.yandex-team.ru/travel/buses/backend/proto"
)

type LazyStringer func() string

func (s LazyStringer) String() string {
	return s()
}

func RideStringer(ride *pb.TRide) fmt.Stringer {
	return LazyStringer(func() string {
		var (
			departurePK, _ = DumpPointKey(ride.From)
			arrivalPK, _   = DumpPointKey(ride.To)
			departureTime  = ConvertRideSecondsToTime(ride.DepartureTime, time.UTC).Format("2006-01-02T15:04:05")
			arrivalTime    = ConvertRideSecondsToTime(ride.ArrivalTime, time.UTC).Format("2006-01-02T15:04:05")
		)
		return fmt.Sprintf(
			"[Id: %v, SupplierId: %v, From: [%v], To: [%v], DepartureTime: [%v], ArrivalTime: [%v]]",
			ride.Id,
			ride.SupplierId,
			departurePK,
			arrivalPK,
			departureTime,
			arrivalTime,
		)
	})
}
