package utils

import (
	"time"

	"a.yandex-team.ru/travel/proto"
)

func ConvertProtoDateToTime(d *travel_commons_proto.TDate) time.Time {
	return time.Date(int(d.Year), time.Month(d.Month), int(d.Day), 0, 0, 0, 0, time.UTC)
}

func ConvertTimeToProtoDate(t time.Time) *travel_commons_proto.TDate {
	return &travel_commons_proto.TDate{Year: int32(t.Year()), Month: int32(t.Month()), Day: int32(t.Day())}
}

func ConvertRideSecondsToTime(secs int64, timezone *time.Location) time.Time {
	t := time.Unix(secs, 0).UTC()
	return time.Date(
		t.Year(), t.Month(), t.Day(), t.Hour(), t.Minute(), t.Second(), 0, timezone,
	)
}

func ConvertTimeToRideSeconds(t time.Time) int64 {
	return time.Date(
		t.Year(), t.Month(), t.Day(), t.Hour(), t.Minute(), t.Second(), 0, time.UTC,
	).Unix()
}
