package yt

import (
	"context"
	"fmt"

	"a.yandex-team.ru/travel/library/go/vault"
	"a.yandex-team.ru/yt/go/ypath"
	"a.yandex-team.ru/yt/go/yt"
	"a.yandex-team.ru/yt/go/yt/ythttp"
	"a.yandex-team.ru/yt/go/ytlock"
)

type ClientConfig struct {
	LockCluster string `config:"ytlockclient-lockcluster,required"`
	LockPath    string `config:"ytlockclient-lockpath,required"`
	Secret      string `config:"ytlockclient-secret,required"`
	SecretKey   string `config:"ytlockclient-secretkey,required"`
}

var DefaultConfig = ClientConfig{
	LockCluster: "locke",
}

var MockedYtClientConfig = ClientConfig{
	LockCluster: "dummy",
}

func NewYtLockClient(config ClientConfig, secretResolver *vault.YavSecretsResolver) (yt.Client, error) {
	if config == MockedYtClientConfig {
		return nil, nil
	}

	ytToken, err := secretResolver.GetSecretValue(config.Secret, config.SecretKey)
	if err != nil {
		return nil, fmt.Errorf("NewYtLockClient. error resolving secret %w", err)
	}
	ytLockClient, err := ythttp.NewClient(
		&yt.Config{
			Proxy: config.LockCluster,
			Token: ytToken,
		},
	)
	if err != nil {
		return nil, fmt.Errorf("NewApp: failed to create ytLock client: %w", err)
	}

	return ytLockClient, nil
}

func AcquireMaster(config ClientConfig, ytLockClient yt.Client, ctx context.Context) bool {
	if config == MockedYtClientConfig {
		return false
	}
	lockPath := ypath.Path(config.LockPath)
	masterLock := ytlock.NewLock(ytLockClient, lockPath)
	if _, err := masterLock.Acquire(ctx); err != nil {
		return false
	}
	return true
}
