package app

import (
	"context"

	tpb "a.yandex-team.ru/travel/proto"

	"a.yandex-team.ru/travel/buses/backend/internal/common/connector"
	wpb "a.yandex-team.ru/travel/buses/backend/proto/worker"
)

func (a *App) Book(_ context.Context, request *wpb.TBookRequest) (response *wpb.TBookResponse, err error) {

	defer a.communicationLogger.SendLog(wpb.ECommunicationLogRecordType_LRT_WORKER_BOOK, request.GetHeader(),
		request, response.GetHeader(), response.GetOrder())

	client, err := connector.NewClient(&a.cfg.Connector, request.SupplierId, a.logger)
	if err != nil {
		a.logger.Errorf("App.Book: %s", err.Error())
		return &wpb.TBookResponse{Header: headerFromError(err)}, nil
	}

	order, explanation, err := client.PostBook(request.RideId, request.Contacts, request.Passengers)
	if err != nil {
		a.logger.Errorf("App.Book: %s", err.Error())
		header := headerFromError(err)
		header.Explanation = explanation
		return &wpb.TBookResponse{Header: header}, nil
	}

	return &wpb.TBookResponse{
		Header: &wpb.TResponseHeader{
			Code:        tpb.EErrorCode_EC_OK,
			Explanation: explanation,
		},
		Order: order,
	}, nil
}
