package app

import (
	"context"
	"fmt"

	tpb "a.yandex-team.ru/travel/proto"

	"a.yandex-team.ru/travel/buses/backend/internal/common/connector"
	tcpb "a.yandex-team.ru/travel/buses/backend/proto/testcontext"
	wpb "a.yandex-team.ru/travel/buses/backend/proto/worker"
)

func (a *App) BookParams(
	ctx context.Context, request *wpb.TBookParamsRequest,
) (response *wpb.TBookParamsResponse, err error) {
	const logMessage = "App.BookParams"

	defer a.communicationLogger.SendLog(wpb.ECommunicationLogRecordType_LRT_WORKER_BOOK_PARAMS, request.GetHeader(),
		request, response.GetHeader(), response.GetBookParams())

	client, err := connector.NewClient(&a.cfg.Connector, request.SupplierId, a.logger)
	if err != nil {
		a.logger.Errorf("%s: %s", logMessage, err.Error())
		return &wpb.TBookParamsResponse{Header: headerFromError(err)}, nil
	}

	header := request.GetHeader()
	if header != nil && header.GetTestContextToken() != "" {
		testContextGetBookParamsResponse, err := a.testContextServiceClient.GetBookParams(ctx,
			&tcpb.TTestContextGetRequest{TestContextToken: header.TestContextToken})
		if err != nil {
			return &wpb.TBookParamsResponse{Header: headerFromError(
				fmt.Errorf("%s: %w", logMessage, err))}, nil
		}
		if testContextGetBookParamsResponse.GetPayload() == nil ||
			testContextGetBookParamsResponse.Payload.GetResponse() == nil {
			err = fmt.Errorf("got bad response from TestContext: no payload")
			return &wpb.TBookParamsResponse{Header: headerFromError(err)}, nil
		}
		return testContextGetBookParamsResponse.Payload.Response, nil
	}

	bookParams, _, explanation, err := client.GetBookParams(request.RideId)
	if err != nil {
		a.logger.Errorf("%s: %s", logMessage, err.Error())
		header := headerFromError(err)
		header.Explanation = explanation
		return &wpb.TBookParamsResponse{Header: header}, nil
	}
	return &wpb.TBookParamsResponse{
		Header: &wpb.TResponseHeader{
			Code:        tpb.EErrorCode_EC_OK,
			Explanation: explanation,
		},
		BookParams: bookParams,
	}, nil
}
