package app

import (
	"context"

	tpb "a.yandex-team.ru/travel/proto"

	"a.yandex-team.ru/travel/buses/backend/internal/common/connector"
	wpb "a.yandex-team.ru/travel/buses/backend/proto/worker"
)

func (a *App) Confirm(_ context.Context, request *wpb.TConfirmRequest) (response *wpb.TConfirmResponse, err error) {

	defer a.communicationLogger.SendLog(wpb.ECommunicationLogRecordType_LRT_WORKER_CONFIRM, request.GetHeader(),
		request, response.GetHeader(), response.GetOrder())

	client, err := connector.NewClient(&a.cfg.Connector, request.SupplierId, a.logger)
	if err != nil {
		a.logger.Errorf("App.Confirm: %s", err.Error())
		return &wpb.TConfirmResponse{Header: headerFromError(err)}, nil
	}

	order, explanation, err := client.PostConfirm(request.OrderId)
	if err != nil {
		a.logger.Errorf("App.Confirm: %s", err.Error())
		header := headerFromError(err)
		header.Explanation = explanation
		return &wpb.TConfirmResponse{Header: header}, nil
	}

	return &wpb.TConfirmResponse{
		Header: &wpb.TResponseHeader{
			Code:        tpb.EErrorCode_EC_OK,
			Explanation: explanation,
		},
		Order: order,
	}, nil
}
