package app

import (
	"context"

	tpb "a.yandex-team.ru/travel/proto"

	"a.yandex-team.ru/travel/buses/backend/internal/common/connector"
	wpb "a.yandex-team.ru/travel/buses/backend/proto/worker"
)

func (a *App) Refund(_ context.Context, request *wpb.TRefundRequest) (response *wpb.TRefundResponse, err error) {

	defer a.communicationLogger.SendLog(wpb.ECommunicationLogRecordType_LRT_WORKER_REFUND, request.GetHeader(),
		request, response.GetHeader(), response.GetRefund())

	client, err := connector.NewClient(&a.cfg.Connector, request.SupplierId, a.logger)
	if err != nil {
		a.logger.Errorf("App.Refund: %s", err.Error())
		return &wpb.TRefundResponse{Header: headerFromError(err)}, nil
	}

	refund, explanation, err := client.PostRefund(request.TicketId)
	if err != nil {
		a.logger.Errorf("App.Refund: %s", err.Error())
		header := headerFromError(err)
		header.Explanation = explanation
		return &wpb.TRefundResponse{Header: header}, nil
	}

	return &wpb.TRefundResponse{
		Header: &wpb.TResponseHeader{
			Code:        tpb.EErrorCode_EC_OK,
			Explanation: explanation,
		},
		Refund: refund,
	}, nil
}
