package app

import (
	"context"

	tpb "a.yandex-team.ru/travel/proto"

	"a.yandex-team.ru/travel/buses/backend/internal/common/connector"
	wpb "a.yandex-team.ru/travel/buses/backend/proto/worker"
)

func (a *App) RefundInfo(ctx context.Context, request *wpb.TRefundInfoRequest) (response *wpb.TRefundInfoResponse, err error) {

	defer a.communicationLogger.SendLog(wpb.ECommunicationLogRecordType_LRT_WORKER_REFUND_INFO, request.GetHeader(),
		request, response.GetHeader(), response.GetRefundInfo())

	client, err := connector.NewClient(&a.cfg.Connector, request.SupplierId, a.logger)
	if err != nil {
		a.logger.Errorf("App.RefundInfo: %s", err.Error())
		return &wpb.TRefundInfoResponse{Header: headerFromError(err)}, nil
	}

	refundInfo, explanation, err := client.GetRefundInfo(request.TicketId)
	if err != nil {
		a.logger.Errorf("App.RefundInfo: %s", err.Error())
		header := headerFromError(err)
		header.Explanation = explanation
		return &wpb.TRefundInfoResponse{Header: header}, nil
	}

	return &wpb.TRefundInfoResponse{
		Header: &wpb.TResponseHeader{
			Code:        tpb.EErrorCode_EC_OK,
			Explanation: explanation,
		},
		RefundInfo: refundInfo,
	}, nil
}
