package app

import (
	"context"

	tpb "a.yandex-team.ru/travel/proto"

	wpb "a.yandex-team.ru/travel/buses/backend/proto/worker"
)

func (a *App) Search(_ context.Context, request *wpb.TSearchRequest) (*wpb.TSearchResponse, error) {
	position, err := a.searchTaskQueue.Push(request)
	if err != nil {
		a.logger.Errorf("App.Search: %s", err.Error())
		return &wpb.TSearchResponse{
			Header: &wpb.TResponseHeader{
				Code: tpb.EErrorCode_EC_GENERAL_ERROR,
				Error: &tpb.TError{
					Code:    tpb.EErrorCode_EC_GENERAL_ERROR,
					Message: err.Error(),
				},
			},
		}, nil
	}
	return &wpb.TSearchResponse{
		Header: &wpb.TResponseHeader{
			Code: tpb.EErrorCode_EC_OK,
		},
		QueuePosition: uint32(position),
	}, nil
}
