package task

import (
	"context"

	"a.yandex-team.ru/library/go/core/log/zap"
	"a.yandex-team.ru/library/go/core/metrics"
	"a.yandex-team.ru/travel/buses/backend/internal/common/connector"
	"a.yandex-team.ru/travel/buses/backend/internal/common/dict"
	workerLogging "a.yandex-team.ru/travel/buses/backend/internal/worker/logging"
	"a.yandex-team.ru/travel/buses/library/go/worker"
	"a.yandex-team.ru/travel/library/go/logbroker"
)

type SearchWorker struct {
	supplierWorkers []*worker.Worker
}

func NewSearchWorker(
	queue *SearchTaskQueue,
	cfg *connector.Config,
	searchProducer *logbroker.Producer,
	logger *zap.Logger,
	communicationLogger *workerLogging.CommunicationLogWriter,
	metricsRegistry metrics.Registry,
) *SearchWorker {
	var supplierWorkers []*worker.Worker
	for _, supplierID := range dict.GetSuppliersList() {
		supplier, _ := dict.GetSupplier(supplierID)
		worker := worker.NewWorker(NewSearchTask(
			queue,
			cfg,
			searchProducer,
			supplier,
			logger,
			communicationLogger,
			metricsRegistry,
		))
		supplierWorkers = append(supplierWorkers, worker)
	}
	return &SearchWorker{
		supplierWorkers: supplierWorkers,
	}
}

func (sw *SearchWorker) Run(ctx context.Context) {
	for _, worker := range sw.supplierWorkers {
		worker.Run(ctx)
	}
}
