# -*- coding: utf-8 -*-
import logging.config
import sentry_sdk

from errorboosterclient.sentry import ErrorBoosterTransport
from errorboosterclient.uagent import UnifiedAgentSender
from flask import Flask
from flask_cors import CORS
from flask_restful import Api
from sentry_sdk.integrations.logging import LoggingIntegration

import config

logging.config.dictConfig(config.Log.get_config_dict())
if config.Log.ERROR_BOOSTER_ENABLED:
    sentry_sdk.init(
        transport=ErrorBoosterTransport(
            project='travel-buses-connectors',
            sender=UnifiedAgentSender(),
        ),
        integrations=[
            LoggingIntegration(
                level=config.Log.ERROR_BOOSTER_BREADCRUMBS_LEVEL,
                event_level=config.Log.ERROR_BOOSTER_EVENT_LEVEL,
            ),
        ],
        environment=config.ENVIRONMENT,
    )

app = Flask(__name__)
api = Api(app)
CORS(app, origins='*')
