# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from flask import Response, current_app as app
from werkzeug.exceptions import ServiceUnavailable

from util.resource import Resource


class Ping(Resource):
    routes = ('/ping',)

    @staticmethod
    def get():
        if not app.config['CLIENTS']:
            raise ServiceUnavailable('connector clients are not initialized')
        return Response('pong!')
