# -*- coding: utf-8 -*-
from connector.resources.connector_resource import ConnectorResource

from yabus.common.exceptions import InvalidIdentifier
from yabus.common.fields import ValidationError
from yabus.common import Identifier


class BookParams(ConnectorResource):
    routes = ('/rides/<ride_id>/book-params',)

    def get(self, ride_id):
        ride_id = Identifier.loads(ride_id)
        try:
            return self.client.ride_details(ride_id)
        except ValidationError:
            raise InvalidIdentifier
