# -*- coding: utf-8 -*-
from connector.resources.connector_resource import ConnectorResource
from flask import current_app as app


class RawSegments(ConnectorResource):
    routes = ('/rides/raw_segments',)

    def get(self):
        return self.client.raw_segments()

    def dispatch_request(self, connector_name, **kwargs):
        timeout = (app.config['SLOW_RESOURCE_TIMEOUT']
                   if connector_name in app.config['SLOW_CONNECTORS'] and 'segments' in app.config['SLOW_RESOURCES']
                   else app.config['RESOURCE_TIMEOUT']
                   )
        return super(RawSegments, self).dispatch_request(connector_name, timeout=timeout)
