# -*- coding: utf-8 -*-
from flask_restful import inputs

from connector.resources.connector_resource import ConnectorResource


class Search(ConnectorResource):
    routes = ('/rides/search',)

    def __init__(self):
        super(Search, self).__init__(params={
            'from-id': {'dest': 'from_uid', 'required': True},
            'to-id': {'dest': 'to_uid', 'required': True},
            'date': {'type': inputs.date, 'required': True},
            'try-no-cache': {'dest': 'try_no_cache', 'type': inputs.boolean, 'required': False, 'default': False},
        })

    def get(self, from_uid, to_uid, date, try_no_cache=False):
        return self.client.search(from_uid, to_uid, date, try_no_cache)
