# -*- coding: utf-8 -*-
from connector.resources.connector_resource import ConnectorResource

from yabus.common import Identifier


class RideVariation(ConnectorResource):
    routes = ('/rides/<ride_id>/variation',)

    def __init__(self):
        super(RideVariation, self).__init__(params={
            'pickup-sid': {'dest': 'pickup_sid', 'required': False},
            'discharge-sid': {'dest': 'discharge_sid', 'required': False},
        })

    def get(self, ride_id, pickup_sid, discharge_sid):
        ride_id = Identifier.loads(ride_id)
        return {
            '@id': Identifier(
                self.client.change_ride_endpoints(ride_id, pickup_sid, discharge_sid),
            ).dumps()
        }
