# -*- coding: utf-8 -*-
from connector.resources.connector_resource import ConnectorResource

from yabus.common import Identifier


class CalcRefund(ConnectorResource):
    routes = ('/tickets/<ticket_id>/calc-refund',)

    def get(self, ticket_id):
        ticket_id = Identifier.loads(ticket_id)
        return self.client.refund_info(ticket_id=ticket_id)


class Refund(ConnectorResource):
    routes = ('/tickets/<ticket_id>/refund',)

    def post(self, ticket_id):
        ticket_id = Identifier.loads(ticket_id)
        return self.client.refund(ticket_id=ticket_id)
