# coding: utf-8
from __future__ import absolute_import, division, print_function

import re

URI_PATTERN = re.compile(r'''
    ^/[a-z\-]+/
    (?:
        orders/([^/]+) |
        orders/([^/]+)/confirm |

        rides/endpoints |
        rides/raw_segments |
        rides/search |
        rides/segments |
        rides/([^/]+) |
        rides/([^/]+)/book |
        rides/([^/]+)/book-params |
        rides/([^/]+)/calc-promo |
        rides/([^/]+)/variation |

        tickets/([^/]+)/blank |
        tickets/([^/]+)/calc-refund |
        tickets/([^/]+)/cancel |
        tickets/([^/]+)/refund
    )$
''', re.VERBOSE)


def _normalize_uri(uri, repl='ID'):
    match = URI_PATTERN.match(uri)
    if match is None:
        return 'UNKNOWN'

    for i, group in enumerate(match.groups(), start=1):
        if group is not None:
            return uri[:match.start(i)] + repl + uri[match.end(i):]

    return uri


def nginx_log_normalize_record(record):
    if record.request.startswith('HEAD ') and record.uri == '/':  # awacs ping
        return []
    return [_normalize_uri(record.uri)]
