# -*- coding: utf-8 -*-
import patch_gevent_hub  # noqa: F401 (monkey patching module)
from os import environ as env
from importlib import import_module

import requests
import six
from gevent.threadpool import ThreadPool as NativeThreadPool
from gunicorn.app.base import Application as BaseApplication
from gunicorn.workers.ggevent import GeventPyWSGIWorker as BaseWorker

from app import app, api

if six.PY2:
    import scandir  # noqa: F401 (we have to import scandir in advance because its import crashes gevent pool)

import sys
reload(sys)
sys.setdefaultencoding('utf-8')  # FIXME

requests.packages.urllib3.util.ssl_.DEFAULT_CIPHERS += ':!DH'  # workaround of OpenSSL DH_KEY_TOO_SMALL errors


class Application(BaseApplication):
    gunicorn_config = {
        'bind': env.get('APP_BIND', 'unix:/tmp/app.sock'),
        'worker_class': 'run.Worker',
        'worker_connections': 1000,
        'pidfile': '/tmp/connectors.pid'
    }

    def __init__(self, app):
        self.app = app
        super(Application, self).__init__("%(prog)s [OPTIONS]")

    def init(self, parser, opts, args):
        self.app.config.from_object('config')
        connectors = frozenset(map(str.strip, env['API_RESOURCES'].split(',')))
        self.gunicorn_config['timeout'] = (
            self.app.config['SLOW_RESOURCE_TIMEOUT']
            if connectors & self.app.config['SLOW_CONNECTORS']
            else self.app.config['RESOURCE_TIMEOUT'] + 10
        )
        for k, v in self.gunicorn_config.iteritems():
            if getattr(opts, k, None) is None:
                setattr(opts, k, v)

    def load(self):
        return self.app


class Worker(BaseWorker):
    def patch(self, *args, **kwargs):
        super(Worker, self).patch(*args, **kwargs)
        module = import_module(env['API_COMPONENT'], __package__)
        module.get_setup()(app)
        for resource in module.get_resources():
            api.add_resource(resource, *resource.routes)
        services = module.get_services()
        self._services_pool = NativeThreadPool(maxsize=len(services))
        for service in services:
            self._services_pool.spawn(service().run)


def main():
    Application(app).run()


if __name__ == '__main__':
    main()
