# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals

import json

from yabus import providers
from yabus.carrier_matcher import carrier_matcher


def main():
    providers.setup(auto_update=False)
    carrier_matcher.setup()

    score = 0
    total = 0
    uniq = set()

    with open('/app/scripts/data.txt') as f:
        for l in f:
            l = json.loads(l)
            uniq.add((l['supplierCode'], l['carrierCode']))

        for a, b in uniq:
            if not a or not b:
                continue
            total += 1
            c = carrier_matcher.get_carrier(a, b)
            if c:
                score += 1
            else:
                print(a)
                print(b.encode('utf-8'))

    print(score, total)


if __name__ == '__main__':
    main()
