# -*- coding: utf-8 -*-
from flask_restful import abort as original_flask_restful_abort


def abort(http_status_code, **kwargs):
    error = kwargs.pop('error', None)
    if error:
        message = error.args[0] if len(error.args) > 0 else ''
        kwargs['error'] = {
            'code': error.code,
            'message': message,
        }
        kwargs['message'] = message
    original_flask_restful_abort(http_status_code, **kwargs)
