# -*- coding: utf-8 -*-
from xmlrpclib import Fault, ServerProxy


PARTNERS = {}


class BillingError(Exception):
    pass


class SimpleClient(object):
    def __init__(self, uri, service_token, operator_uid):
        self._rpc = ServerProxy(uri, allow_none=True).BalanceSimple
        self._service_token = service_token
        self._operator_uid = operator_uid

    def create_partner(self, partner):
        billing_id = self.CreatePartner(operator_uid=self._operator_uid, **partner)['partner_id']
        return billing_id

    def load_partner(self, billing_id):
        self.LoadPartner(partner_id=billing_id)

    def create_product(self, partner_id, billing_id, product_name):
        service_product_id = '-'.join([partner_id, product_name])
        self.CreateServiceProduct(service_product_id=service_product_id, partner_id=billing_id, name=product_name)

    def __getattr__(self, attr):
        method = getattr(self._rpc, attr)

        def wrapper(**kwargs):
            retval = method(self._service_token, kwargs)
            if retval.get('status') != 'success':
                raise BillingError(retval.get('status_code'), retval.get('status_desc'))
            return retval

        return wrapper


class Client(object):
    def __init__(self, uri, operator_uid):
        self._rpc = ServerProxy(uri, allow_none=True).Balance
        self._operator_uid = operator_uid

    def get_partners(self, ids):
        code, partners = self._rpc.GetClientByIdBatch(ids)
        if code != 0:
            raise BillingError(code, "failure")
        return [self._lowerise(x) for x in partners]

    def create_person(self, person):
        try:
            return self._rpc.CreatePerson(self._operator_uid, person)
        except Fault as e:
            raise BillingError(e.faultCode, e.faultString)

    def get_partner_persons(self, billing_id):
        persons = self._rpc.GetClientPersons(billing_id)
        return [self._lowerise(x) for x in persons]

    @staticmethod
    def _lowerise(kv):
        return {k.lower(): v for k, v in kv.items()}
