# -*- coding: utf-8 -*-
import requests

from os.path import join


class Bunker(object):
    def __init__(self, api):
        self.api = api
        if not self.api.endswith('/'):
            self.api += '/'

    def cat(self, node, version='stable'):
        params = {
            'node': node,
            'version': version,
        }
        try:
            request = requests.get(join(self.api, 'cat'), params=params)
            request.raise_for_status()
            return request.json()
        except:
            return None
